# 🚀 Painel de Recargas 1.0

Sistema de automação para Lovable.dev com controle remoto via Telegram.

## 📋 Funcionalidades

- ✅ Automação de Remix, Publish e Rename
- ✅ Múltiplas instâncias simultâneas (portas 3008-3011)
- ✅ Controle remoto via Telegram (Start/Stop)
- ✅ Notificações de progresso em tempo real
- ✅ Interface web bonita e responsiva

---

## ⚙️ Instalação

### 1. Pré-requisitos
- Node.js 18+ instalado
- Microsoft Edge instalado (usado pelo Playwright)

### 2. Instalar dependências
```bash
npm install
```

### 3. Instalar navegadores do Playwright
```bash
npx playwright install msedge
```

### 4. Configurar Telegram (opcional)
1. Copie o arquivo de exemplo:
   ```bash
   cp config.example.json config.json
   ```
2. Edite `config.json` e preencha:
   - `telegramBotToken`: Token do seu bot (crie em @BotFather)
   - `telegramChatId`: Seu ID de chat (descubra em @userinfobot)

---

## 🚀 Como Usar

### Iniciar uma instância
```bash
PORT=3008 node src/server.js
```

### Iniciar múltiplas instâncias (Windows)
Execute o arquivo `INICIAR PAINEL.bat`

### Iniciar múltiplas instâncias (Mac/Linux)
```bash
PORT=3008 node src/server.js &
PORT=3009 node src/server.js &
PORT=3010 node src/server.js &
PORT=3011 node src/server.js &
```

### Acessar o painel
Abra no navegador:
- http://localhost:3008
- http://localhost:3009
- http://localhost:3010
- http://localhost:3011

---

## 📱 Controle via Telegram

Após configurar o bot, envie estes comandos:

| Comando | Descrição |
|---------|-----------|
| `/painel` | Exibe painel de controle com botões |
| `/start` | Mensagem de boas-vindas |
| `/menu` | Igual ao /painel |

O painel mostra botões para **Iniciar** e **Parar** cada instância.

> ⚠️ **Importante:** A instância 3008 é a "mestre" que recebe os comandos do Telegram e repassa para as outras.

---

## 📁 Estrutura de Arquivos

```
painel creditos/
├── config.json          # Suas configurações (NÃO COMPARTILHAR!)
├── config.example.json  # Exemplo para novos usuários
├── src/
│   ├── server.js        # Servidor Express + WebSocket
│   └── services/
│       ├── remixAutomationService.js  # Lógica de automação
│       └── notificationService.js     # Integração Telegram
├── public/
│   ├── index.html       # Interface do painel
│   ├── css/style.css    # Estilos
│   └── js/app.js        # JavaScript do frontend
└── INICIAR PAINEL.bat   # Script Windows para iniciar
```

---

## ❓ Solução de Problemas

### "Connection Refused"
Os servidores não estão rodando. Execute novamente os comandos de inicialização.

### "Botão Remix não encontrado"
O site Lovable pode ter mudado. Verifique se você está logado e na página correta.

### Telegram não responde
1. Verifique se o token e chat ID estão corretos
2. Certifique-se que a porta 3008 está rodando (ela é a mestre)

---

## 📜 Licença

Uso pessoal. Não redistribuir comercialmente.
